'-------------------------------------------------------------------------------
'                       ATTENUATOR
'
' Runs on CSE211003 PCB
' Processor ATMega168 or 328
'
'-------------------------------------------------------------------------------
$regfile = "m168pdef.dat"
$hwstack = 32
$swstack = 32
$framesize = 32
$crystal = 8000000
Config Clockdiv = 1                               '


Ddrb = &B0000_0111                                ' Port B
Portb = &B1111_1000

Ddrc = &B100_0000                                 ' Port C direction
Portc = &B000_1111

Ddrd = &B1110_0000
Portd = &B0001_1111

Dim Lsd As Byte                                   ' least significant digit
Dim Tens As Byte                                  ' tens digit
Dim Delay_time As Byte

Dim Attenuation As Integer                        ' from 0 - 110
Dim Direction As Bit                              'rotary encoder direction
Dim Increase As Bit
Dim Decrease As Bit
Dim All_zero As Bit
Dim Update As Bit
Dim Db_step As Bit
Dim 1_or_10 As Bit

Config Scl = Portc.5                                        ' used i2c pins
Config Sda = Portc.4
Config Twi = 100000                               ' i2c speed
Config Com1 = 115200 , Synchrone = 0 , Parity = None , Stopbits = 1 , Databits = 8 , Clockpol = 0

I2cinit

$lib "i2c_twi.lbx"                                          ' we do not use software emulated I2C but the TWI
$lib "glcdSSD1306-I2C.lib"                                  ' override the default lib with this special one

Config Graphlcd = Custom , Cols = 128 , Rows = 64 , Lcdname = "SSD1306"
Cls

Setfont Font16x16                                 ' select font
Cr Alias &H0D                                     ' carriage return

' Ten relays are used to set different attenuators

1db_switch Alias Portc.3
2db_switch Alias Portc.2
3db_switch Alias Portc.1
5db_switch Alias Portc.0
10db_switch_1 Alias Portb.2
10db_switch_2 Alias Portb.1
20db_switch_1 Alias Portd.5
20db_switch_2 Alias Portd.6
20db_switch_3 Alias Portd.7
20db_switch_4 Alias Portb.0

Config Timer0 = Timer , Prescale = 256
Timer0 = 255 - 78

' Timer0 interrupts ~100/second
Config Int0 = Falling
Config Int1 = Falling

On Timer0 100hz_interrupt
On Int0 Rotary_encoder
On Int1 Step_size


Enable Int0
Enable Int1

Enable Interrupts

 Print "Attenuator Ver.2.0" ; Chr(cr);
 Gosub Splash_screen
 Wait 1
 Lcdat 5 , 1 , "        " , 2
 Gosub Display_attenuation
 Gosub Show_step

' **************************** MAIN **************************************
'
' Cycle through this loop updating relays.


Main:


   If 1_or_10 = 1 Then Gosub Show_step
   If Increase = 1 Then Gosub Higher_atten
   If Decrease = 1 Then Gosub Lower_atten
   If Update = 1 Then Gosub Set_attenuation
   Goto Main                                      ' loop



 Show_step:
    1_or_10 = 0
    If Db_step = 0 Then Lcdat 7 , 1 , " Step 1" , 2
    If Db_step = 1 Then Lcdat 7 , 1 , " Step 5" , 2
    Return

' ******************************** ATTENUATION **********************************
'
Higher_atten:
   Increase = 0
   If Db_step = 0 Then Incr Attenuation
   If Db_step = 1 Then Attenuation = Attenuation + 5
   If Attenuation > 110 Then Attenuation = 110    ' no higher than 110
   Gosub Display_attenuation
   Return

' ---------------------------------------------------------------------------------

Lower_atten:
   Decrease = 0
   If Db_step = 0 Then Decr Attenuation
   If Db_step = 1 Then Attenuation = Attenuation - 5
   If Attenuation < 0 Then Attenuation = 0        ' not below 0
   Gosub Display_attenuation

   Return

' ---------------------------------------------------------------------------------


Display_attenuation:
  ' Lcdat 5 , 1 , "        " , 2
   Lcdat 3 , 1 , " " ; Attenuation ; " dB " , 2

   Timer0 = 255 - 78                              ' 1/8 second delay
   Enable Timer0
   Return

' ******************************* SET ATTENUATION ************************************
'
' Calculate relays state from attenuation number
  Dim Decades As Byte

Set_attenuation:
   Update = 0
   Disable Timer0
  ' Print "Attenuation = " ; Attenuation ; " dB " ; Chr(cr);
   Tens = Attenuation / 10
   'Print "Tens = " ; Tens ;
   Gosub Tens_relays
   Lsd = Attenuation Mod 100                      ' gives 0-9
   If Tens < 10 Then Decades = Tens * 10
   If Tens < 10 Then Lsd = Lsd - Decades
   'Print " Ones = " ; Lsd ;
   Gosub Up_to_10
  ' Lcdat 7 , 1 , Hex(portd) ; " " ; Hex(portb) ; " " ; Hex(portc)
   'Lcdat 7 , 1 , "        " , 2

   Return

' turn on all 10 and 20 dB relays with pause in between to reduce noise

Turn_on_100:
   Portb = 7
   Portd = &HE0
   'Print " Tens Relays " ; Bin(portb) ; " " ; Bin(portd) ; Chr(cr);

   Return

' turn off all 10 and 20 dB relays with pause in between to reduce noise

Turn_off_100:
   Portb = 0
   Portd = 0
   Return

' Tens relays sets the 10 dB and 20 dB relays

Tens_relays:

   If Tens = 0 Then Portd = 0
   If Tens = 0 Then Portb = 0                     ' all relays off
   If Tens = 1 Then Portb.2 = 1                   ' 10 dB relay
   If Tens = 1 Then Portd.5 = 0
   If Tens = 2 Then Portd.5 = 1                   ' 20 dB relay
   If Tens = 2 Then Portb.2 = 0                   ' 10 dB relay off
   If Tens = 3 Then Portd.5 = 1                   ' 20 dB relay
   If Tens = 3 Then Portb.2 = 1                   ' plus 10 dB relay
   If Tens = 4 Then Portd = &H60                  ' 20 dB relay 1 and 2
   If Tens = 4 Then Portb.2 = 0                   ' 10 dB relay off
   If Tens = 5 Then Portd = &H60                  ' 20 dB relay 1 and 2
   If Tens = 5 Then Portb = 4                     ' plus 10 dB relay
   If Tens = 6 Then Portd = &HE0                  ' 20 dB relay 1, 2 and 3
   If Tens = 6 Then Portb = 0                     '
   If Tens = 7 Then Portd = &HE0                  ' 20 dB relay 1, 2 and 3
   If Tens = 7 Then Portb = 4                     ' plus 10 dB relay
   If Tens = 8 Then Portd = &HE0                  ' 20 dB relay 1, 2 and 3
   If Tens = 8 Then Portb = 6                     ' plus 10 dB relays 1 and 2
   If Tens = 9 Then Portd = &HE0                  ' 20 dB relay 1, 2 and 3
   If Tens = 9 Then Portb = 3                     ' plus 10 dB and 20 dB
   If Tens = 10 Then Portb = 7                    ' plus 10 dB relays 1 , 2 and 3
   If Tens = 10 Then Portd = &HE0
   'Print " Tens Relays " ; Bin(portb) ; " " ; Bin(portd) ; Chr(cr);
   Return



' Up to 10 turns on a combination of relays for 1 - 9 dB.

Up_to_10:
   If Lsd = 0 Then Portc = 0                      ' all relays off
   If Lsd = 1 Then Portc = 8                      ' 1 dB relay
   If Lsd = 2 Then Portc = 4                      ' 2 dB relay
   If Lsd = 3 Then Portc = 2                      ' 3 dB relay
   If Lsd = 4 Then Portc = &H0A                   ' 3 db plus 1 dB relay
   If Lsd = 5 Then Portc = 1                      ' 5 dB relay
   If Lsd = 6 Then Portc = 9                      ' 5 db plus 1 dB relay
   If Lsd = 7 Then Portc = 5                      ' 5 db plus 2 dB relay
   If Lsd = 8 Then Portc = 3                      ' 5 db plus 3 dB relay
   If Lsd = 9 Then Portc = &H0B                   ' 5 db plus 3 db and 1 dB relay
   If Attenuation = 110 Then Portc = &H0F
   'Print " Relays up to 10 " ; Bin(portc) ; Chr(cr);
   Return




' ********************************* ROTARY ENCODER ************************************************
'
' Rotary encoder steps attenuation up or down

Rotary_encoder:
   Direction = Pinb.3                             ' read direction
   If Direction = 1 Then Gosub Normal Else Gosub Reverse
   Return

Normal:
   If Pind.4 = 1 Then Increase = 1
   If Pind.4 = 0 Then Decrease = 1
   Return

Reverse:
   If Pind.4 = 0 Then Increase = 1
   If Pind.4 = 1 Then Decrease = 1
   Return

' ******************************** STEP SIZE ***********************************
'
' Toggle Step Size

Step_size:
   Set 1_or_10
   Toggle Db_step
   Return

   ' ******************************** 100HZ INTERRUPT, TIMER0 ****************************************
'
' Timer 0 interrupts every 100 Hz approx.
' Update set 1/4 second after setting attenuation.


100hz_interrupt:
   Timer0 = 255 - 78
   Incr Delay_time
   If Delay_time = 10 Then Set Update
   If Delay_time = 10 Then Delay_time = 0
    Return

Splash_screen:
   Lcdat 1 , 1 , " Atten  " , 2
   Lcdat 5 , 1 , "Ver 2.0 " , 2
   Lcdat 3 , 1 , "        " , 2
   Lcdat 7 , 1 , "        " , 2
   Return

    $include "font16x16.font"